//
//  BPStorageSwitcher.h
//  BISubstrate
//
//  Created by Alykhan Jetha on 2013-06-20.
//
//

#import <Foundation/Foundation.h>

@interface BPStorageSwitcher : NSObject

+ (BPStorageSwitcher *)sharedSwitcher;

/*!
 Returns a list of accounts currently in deep freeze. The array can be empty.
 */
//- (NSArray *)currentFrozenStorages;

/*!
 Moves the current storage, logs and templates into deep freeze. You should have already stopped the sync helper and you should restart the app after (potentially after switching to another account).
 
 Moves the contents into Billings Pro/OtherAccounts/accountname
 */
//- (BOOL)freezeCurrentStorage;

/*!
 Switches the storage, logs and templates of anAccountName, but anAccountName can be nil if switching to a new account. You should restart the app after and you should have stopped sync helper
 */
//- (BOOL)switchToAccount:(NSString *)anAccountName;


- (BOOL)installSampleData:(NSError **)error;

/*!
 Removes the sample data. Make sure database connections are closed before calling this.
 */
- (BOOL)removeSampleData:(NSError **)error;


@end
